/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.loot;

import cofh.lib.util.WeightedRandomDrop;
import cofh.thermal.core.ThermalCore;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class GrassLootModifier
extends LootModifier {
    private final List<WeightedRandomDrop> seedDrops = new ArrayList<WeightedRandomDrop>();

    public GrassLootModifier(LootItemCondition[] conditionsIn, List<String> seeds) {
        super(conditionsIn);
        this.addEntry(Items.f_42404_, 160);
        for (String seed : seeds) {
            this.addEntry(seed, 20);
        }
    }

    public void addEntry(Item seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop(seed, weight));
    }

    public void addEntry(String seed, int weight) {
        this.seedDrops.add(new WeightedRandomDrop((Item)ThermalCore.ITEMS.get(seed), weight));
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        for (ItemStack stack : generatedLoot) {
            if (stack.m_41720_() == Items.f_42404_) {
                WeightedRandom.m_146317_((Random)context.m_78933_(), this.seedDrops).ifPresent(e -> newLoot.add(e.toItemStack(stack.m_41613_())));
                continue;
            }
            newLoot.add(stack);
        }
        return newLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GrassLootModifier> {
        public GrassLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            ArrayList<String> seeds = new ArrayList<String>();
            JsonArray seedlist = GsonHelper.m_13933_((JsonObject)object, (String)"seeds");
            for (JsonElement je : seedlist) {
                seeds.add(je.getAsString());
            }
            return new GrassLootModifier(ailootcondition, seeds);
        }

        public JsonObject write(GrassLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

